//#include "pmc.cpp"
//declaration des prototypes de fonctions
#include <iostream>
#include <stdlib.h>
#include <iomanip>
#include <math.h>
#include <fstream>

#define n 0.1;
using namespace std;

/*******************************************************************************************************/
/*                                           variables globales					       */
/*******************************************************************************************************/

float *poidbcc,*biaiscc,*poidbcs,*biaiscs,**pcc,**pcs,*ys,*yc,*es,*dk,*dj;
float *x;
int *d1;
int nncc;
int nncs;
double eps;
int tmax;
int temps=0;
int **d;
char nomex[10]="data.txt";
float **X;
FILE *f;
int nbrexem;
int nnce;

/*******************************************************************************************************/
/*                                         prototype des fonctions				       */
/*******************************************************************************************************/

void afichemat(float **,int,int);
void afichemat1(int **,int,int);
void poidbiaiscc(float*,float*,int);
void poidbiaiscs(float*,float*,int);
void poidcc(float**,int,int);
void poidcs(float**,int,int);
float sigmoide(float );
void propagationavant(float*,float**,float*,float**,float*,float*,float*,float*,float*,int,int,int );
void erreurdesortie(float*,float*,int*,int);
void deltacs(float*,float*,float*,int);
void actpoidcs(float**,float*,float*,int,int);
void deltacc(float **,float *,float *,float *,int,int);
void actpoidcc(float**,float*,float* ,int,int);
double maxerr(float*,int);
float errlocal(float*,int );
void enregestre_poid(float*,float*,float**,float**,int,int,int);

/*******************************************************************************************************/
/*                                         declaration des fonctions				       */
/*******************************************************************************************************/
//---affiche les donner d'entrées
void afichemat(float **t,int k,int p){  
	for(int l=0;l<k;l++){
		for(int c=0;c<p;c++){
			cout<<t[l][c]<<"\t";
		}
		cout<<endl;
	}
	cout<<endl;
}

//---afficher les sorties déssirées
void afichemat1(int **t,int k,int p){ 
	for(int l=0;l<k;l++){
		for(int c=0;c<p;c++){
			cout<<t[l][c]<<"\t";
		}
		cout<<endl;
	}
	cout<<endl;
}

//---fonction permettant de initiliser le poid synaptique de biais de chaque neuron de la couche cachée
void poidbiaiscc(float *poidbcc,float *biaiscc,int nncc){
	for(int i=0;i<nncc;i++){
		poidbcc[i]=-0.5+(float)rand()/RAND_MAX;
		biaiscc[i]=-1;
	}
}

//---fonction permettant de initiliser le poid synaptique  de chaque neuron de la couche de sortie
void poidbiaiscs(float* poidbcs,float* biaiscs,int nncs){
	for(int i=0;i<nncs;i++){
		poidbcs[i]=-0.5+(float)rand()/RAND_MAX;
		biaiscs[i]=-1;
	}
}

//---fonction permettant de initiliser le poid synaptique de chaque neuron de la couche cachée
void poidcc(float **poidcc,int nncc,int nnce){
	for(int i=0;i<nncc;i++) for(int j=0;j<nnce;j++)
		poidcc[i][j]=-0.5+(float)rand()/RAND_MAX;
}

//---fonction permettant de initiliser le poid synaptique de chaque neuron de la couche de sortie
void poidcs(float** poidcs,int nncs,int nncc){
	for(int i=0;i<nncs;i++) for(int j=0;j<nncc;j++)
		poidcs[i][j]=-0.5+(float)rand()/RAND_MAX;
}

//---la fonction d'activation de neuron
float sigmoide(float v){
  	  return 1/(1 + exp(-(double)v));
}

//---fonction qui va permettre la propagation avant
void propagationavant(float* poidbcc,float** poidcc,float* biaiscc,float** poidcs,float* biaiscs,float* poidbcs,float* yc,float* x,float* ys ,int nnce,int nncc ,int nncs ){
	for(int i=0;i<nncc;i++){
		float sommac=0;  for(int j=0;j<nnce;j++){  sommac+=x[j]*poidcc[i][j];}
		yc[i]=sigmoide(sommac+biaiscc[i]*poidbcc[i]);}
		for(int i=0;i<nncs;i++){
			float sommas=0; 
			for(int j=0;j<nncc;j++){
				sommas+=yc[j]*poidcs[i][j]; 
			}
			 ys[i]=sigmoide(sommas+biaiscs[i]*poidbcs[i]);
		}
}

void erreurdesortie(float* es,float* ys,int* d,int nncs){  
	for(int i=0;i<nncs;i++){
		es[i]=(d[i]-ys[i]);
	}
}

void deltacs(float* dk,float* es ,float* ys ,int nncs){
	for(int i=0;i<nncs;i++)
	dk[i]=es[i]*(ys[i]*(1-ys[i]));    
}

double maxerr(float *es,int nncs){
	double max=es[0];
	for(int i=1;i<nncs;i++) if(max<es[i]) max=es[i];
	return max;
}

void actpoidcs(float** pcs,float* dk,float* yc,int nncc,int nncs){
	for(int i=0;i<nncs;i++)for(int j=0;j<nncc;j++){
		pcs[i][j]=pcs[i][j]+(0.1*dk[i]*yc[j]);
	}
}

void deltacc(float **poidcs,float *dk,float *dj,float *yc,int nncc,int nncs){
	for(int i=0;i<nncc;i++){
		float somme=0;
		for(int j=0;j<nncs;j++){
			somme+=dk[j]*poidcs[j][i];
		}
		dj[i]=yc[i]*(1-yc[i])*somme;
	}
}

void actpoidcc(float **poidcc,float *dj,float* x ,int nncc,int nnce){
	for(int i=0;i<nncc;i++){
		for(int j=0;j<nnce;j++){
			poidcc[i][j]=poidcc[i][j]+0.1*dj[i]*x[j];
		}
	}
}

float errlocal(float* es,int nncs){
	float sum=0.0;
	for(int i=0;i<nncs;i++) sum+=0.5*(es[i]*es[i]);
	return (sum);
}

void enregestre_poid(float *poidbcc,float *poidbcs,float** pcc,float** pcs,int nnce,int nncc,int nncs){
	ofstream file("poids.txt");
	int k=0;
	if(file){
		file<<"poids.txt"<<endl;
		//enregistrer les poids de la couche cachée
		for(int i=0;i<nncc;i++){
			file<<poidbcc[k]<<"\t";
			for(int j=0;j<nnce;j++) file<<pcc[i][j]<<"\t";
			file<<endl;
			k++;
		}
		//enregistrer les poids de la couche de sortie
		k=0;
		for(int i=0;i<nncs;i++){
			file<<poidbcs[k]<<"\t";
			for(int j=0;j<nncc;j++) file<<pcs[i][j]<<"\t";
			file<<endl;
			k++;
		}
		
		file.close();
	}
	else cout<<"impossible d'ouvrir le fichier \"poids.txt\" "<<endl; 
}

int vect_comp(float* v1,int* v2,int t){	
	for(int i=0;i<t;i++) if(v1[i]!=(float)v2[i]) return 0;
	return 1;
}

void resultat(int &comp){
	for(int i=0;i<nbrexem;i++){
		for(int j=0;j<nnce;j++)
		x[j]=X[i][j];
		propagationavant(poidbcc,pcc,biaiscc,pcs, biaiscs,poidbcs,yc,x,ys ,nnce,nncc ,nncs );
		for(int e=0;e<nncs;e++) ys[e]>=0.5 ? ys[e]=1 : ys[e]=0;
			comp+=vect_comp(ys,d[i],nncs);
	}
}
		
/*******************************************************************************************************/
/*                                             fonction main	         			       */
/*******************************************************************************************************/

int main(int argc,char* argv[]){ 
	cout<<"donner le nombre de nueron de couche entre\t\t: "; cin>>nnce;
	cout<<"donner le nombre de nueron de couche cachée\t\t: "; cin>>nncc;
	cout<<"donner le nombre de nueron de couche de sortie\t\t: "; cin>>nncs;
	cout<<"donner le nombre d'exemples\t\t: "; cin>>nbrexem;
	cout<<"donner le nombre d'itération maxxx\t\t: "; cin>>tmax;
	cout<<"l'erreur tolérable eps\t\t: ";cin>>eps;
	X=new float*[nbrexem];
	for(int i=0;i<nbrexem;i++){
		X[i]=new float[nnce];
	}
	d=new int*[nbrexem];
	for(int i=0;i<nbrexem;i++){
		d[i]=new int[nncs];
	}
	d1=new int[nncs];
	f=fopen(nomex,"rt");
 	for(int t=0;t<nbrexem;t++){
		for(int i=0;i<nnce;i++){
			fscanf(f,"%f",&X[t][i]);
		}
		for(int i=0;i<nncs;i++){
			fscanf(f,"%d",&d[t][i]);
		}
	}
	fclose(f);
	afichemat(X,nbrexem,nnce);
	cout<<"____________________________________"<<endl;
	cout<<"________matrice de classes__________"<<endl;
	cout<<"____________________________________"<<endl;
	afichemat1(d,nbrexem,nncs);
 	pcc=new float*[nncc];
	for(int i=0;i<nncc;i++) pcc[i]=new float[nnce];
 	pcs=new float*[nncs];
	for(int i=0;i<nncs;i++) pcs[i]=new float[nncc];
	poidbcc=new float [nncc];
	poidbcs=new float [nncs];
	biaiscc=new float [nncc];
	biaiscs=new float [nncs];
	yc=new float [nncc];
	ys=new float [nncs];
	x=new float[nnce];
	es=new float [nncs];
	dk=new float [nncs];
	dj=new float [nncc];
	poidbiaiscc(poidbcc,biaiscc,nncc);
	poidbiaiscs(poidbcs,biaiscs,nncs);//poids de biais couches de sorties
	poidcc(pcc,nncc,nnce);//poids de couches cachées
	poidcs(pcs,nncs,nncc);//poids de couches de sortie
	float errglob;int v;
	float erloc;
	do{temps++;
                errglob=0.0;
                for(v=0;v<nbrexem;v++){
                	for(int j=0;j<nnce;j++) x[j]=X[v][j];
                	erloc=0.0;
			propagationavant(poidbcc,pcc,biaiscc,pcs, biaiscs,poidbcs,yc,x,ys ,nnce,nncc ,nncs );
			erreurdesortie(es,ys,d[v],nncs);
                	erloc=errlocal(es,nncs);
			deltacs(dk, es ,ys ,nncs);
			actpoidcs(pcs,dk,yc,nncc,nncs);
			deltacc(pcs,dk,dj,yc,nncc,nncs);
			actpoidcc(pcc,dj,x ,nncc,nnce);
			errglob+=erloc;
		}
		int comp=0;
		resultat(comp);
		cout<<"Iteration : "<<temps<<"\t";
		cout<<"Erreur globale	: "<<errglob<<"\t";
		cout<<"(resultat = "<<comp<<"/"<<nbrexem<<" → "<<(float)comp/nbrexem*100<<"%)"<<endl;
	}while((temps<tmax)&&((errglob)>eps));
	enregestre_poid(poidbcc,poidbcs,pcc,pcs,nnce,nncc,nncs);
	cout<<"*************************************************************************************************"<<endl;
	return 0;
}
